#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <limits.h>

using namespace std;

vector<vector<long long>> srediMatricu(vector<long long>& brojevi, int red, int col) {
    // Sort the brojevi in descending order
    sort(brojevi.rbegin(), brojevi.rend());

    // Create an empty matrix
    vector<vector<long long>> matrica(red, vector<long long>(col, 0));

    // Calculate the center of the matrix
    int srednjiRed = red / 2;
    int srednjaKol = col / 2;

    // Assign brojevi to positions based on distance from the center
    for (long long broj : brojevi) {
        // Find the position with the minimum distance to the center
        long long najmanjaDalj = LLONG_MAX;
        pair<int, int> najmanjaPoz;

        for (int i = 0; i < red; ++i) {
            for (int j = 0; j < col; ++j) {
                long long dalj = abs(i - srednjiRed) + abs(j - srednjaKol);
                if (dalj < najmanjaDalj && matrica[i][j] == 0) {
                    najmanjaDalj = dalj;
                    najmanjaPoz = make_pair(i, j);
                }
            }
        }

        // Assign the number to the position with minimum distance
        matrica[najmanjaPoz.first][najmanjaPoz.second] = broj;
    }

    return matrica;
}


long long najdiPodmatrice(int N, int M, int K, int L, vector<vector<long long>> matrica) {
    long long broj = 0;
    for (int i = 0; i <= N - K; i++) {
        for (int j = 0; j <= M - L; j++) {
            int suma = 0;
            for (int x = i; x < i + K; x++) {
                for (int y = j; y < j + L; y++) {
                    suma += matrica[x][y];
                }
            }
            broj += suma;
        }
    }
    return broj;
}


int main() {
    int N, M, K, L;
    std::cin >> N >> M >> K >> L;
    std::vector<long long> brojevi(N * M, 0);

    for (int i = 0; i < N * M; ++i) {
        std::cin >> brojevi[i];
    }


    vector<vector<long long>> sredjenaMatrica = srediMatricu(brojevi, N, M);
    long long broj = najdiPodmatrice(N, M, K, L, sredjenaMatrica);


    cout << broj << endl;

    return 0;
}